/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* expunge APL2 V1.0.0 *************************************************
* Called from endoper to free memory for an aplfunc structure.         *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+APLMEM+APLTOKEN
#include "includes.h"
void *expunge(fp)
struct aplfunc *fp;
{
	Endoper; Execfree; Expungf;
	Apltoken tok;
	Aplcb cb;
	int i;

	if (fp == NULL) return(NULL); /* nothing to free */
	if (NULL != (fp->functext)) {
		fp->functext->aplflags |= APLTEMP; /* mark temporary */
		endoper(fp->functext); /* go free aplcb */
	}
	free(fp->functokp);
	free(fp->functokc);
	expungf(fp->functary, fp->functotl); /* free tokens */
	free(fp); /* free aplfunc structure */
	return(NULL);
}
