/* Copyright (C) 1995 by Thomas Glen Smith.	All Rights Reserved. */
/* expanf APL2 V1.0.0 **************************************************
* Called from expand when rite needs to be replicated along the axis   *
* dimension.                                                           *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb expanf(naxicnt,oaxicnt,axis,botcnt,topcnt,rite)
int	naxicnt,	/* New axis count. */
	oaxicnt,	/* Old axis count. */
	axis,	/* Axis, relative index origin in force. */
	botcnt,	/* Product of dimensions below axis. */
	topcnt;	/* Product of dimensions above axis. */
Aplcb rite;
{
	Dtacopy; Errstop; Getcb; Intcopy;
	extern int aplerr;
	extern int indxorg;
	Aplcb out=NULL;
	int datacnt,datatyp,i,j,k;
	void *vp;
	char *wp;

	for (;;) {
		datacnt = naxicnt * botcnt * topcnt;
		datatyp = rite->aplflags & (APLMASK | APLAPL);
		out = getcb(NULL,datacnt,datatyp+APLTEMP,rite->aplrank,NULL);
		if (out == NULL) break;
		intcopy(out->apldim,rite->apldim,rite->aplrank,1);
		*(out->apldim + axis - indxorg) = naxicnt;
		vp = out->aplptr.aplchar;
		wp = (char *)(rite->aplptr.aplchar);
		for (i = topcnt; i; i--) {
			for (j = naxicnt; j; j--)
				vp = dtacopy(vp, (void *)wp, botcnt, 1, datatyp);
 			wp += botcnt * out->aplsize;
		}
		break;
	}
	return(errstop(0,NULL,rite,out));
}
