/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execspex APL2 V1.0.0 ************************************************
* Called by execspec to determine if the current assignment is a		 *
* selective specification, e.g. (Er)#n, and perform it if so.		 *
***********************************************************************/
#define INCLUDES APLCHDEF+APLDERIV+APLTOKEN+APLCB+TREE
#include "includes.h"
int execspex()
{
	Execfree; Execinit; Execnext; Execspee; Execspep; Execspeq;
	Execsper; Execspeu; Execterm; Pop; Temp;
	extern Treelist treehdr;
	extern int aplerr;
	Apltoken axistok,nametok=NULL,op,tok,wrk;
	int	hit=0,i,namecnt,noexit,savelast,saveperm;
	Aplcb cb,cbn=NULL;
	void *func;
	Avlnode p;
	Treelist treetest;

	treetest = treehdr;
	if (aplerr || NULL == (wrk = treehdr->avltokhd) ||
		wrk->token_code != RIGHT_PAREN)
		return(0); /* not selective specification */
	savelast = treehdr->lastfun;
	treehdr->lastfun = 0;
	for (;;) { /* lets me use break */
		i = execfun(&func); /* pop assignment operator */
		execfree(pop(&(treehdr->avltokhd))); /* pop/free RIGHT_PAREN */
		if (execspep()) { /* Test for form (a b c) # ... */
			execinit(); /* Push a new execstk element on stack */
			noexit = execnext(&tok,&axistok,&op,&namecnt);
			execterm(); /* Pop the execstk element. */
			hit = execspee(tok, axistok, op, namecnt); 
				/* Execspee completes the assignment to a list of */
				/* names, then returns 1 to indicate then assignment */
				/* was completed successfully. */
			break; /* We're all done. */
		}
		nametok = execspeq(&p); /* Get the operand to index? */
		if (nametok == NULL) { aplerr = 58; break; }
		saveperm = nametok->token_flags & TOKPERM;
		if (!saveperm)
			nametok->token_flags |= TOKPERM; /* save name for later */
		i = 0;
		cbn = execspeu(p->avlleaf, &i); /* generate indices */
		if (aplerr) break;
		hit = execsper(p,cbn,nametok); /* Finish processing. */
		break;
	}
	treehdr->lastfun = savelast;
	if (nametok != NULL && !saveperm) {
		nametok->token_flags -= TOKPERM; /* save name for later */
		execfree(nametok);
	}
	endoper(temp(cbn));
	return(hit); /* indicate selective specification handled */
}
