/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execspek APL2 V1.0.0 ************************************************
* Called by execspet to perform selective specification, e.g. (sEr)#n, *
* where E is SLOPE or SLOPE_BAR.                                       *
* (1 0 1 0 1) \ m) # I5 produces 1 3 5.                                *
***********************************************************************/
#define INCLUDES APLCHDEF+APLDERIV+APLTOKEN+APLCB+TREE
#include "includes.h"
int execspek(code, tok, axistok, op)
int code;		   /* funky_code for E in e.g. (sEr)#n */
Apltoken tok,	   /* token of type DERIVED_FUNCTION for E in (sEr)#n */
	    axistok, /* token for x in e.g. (sE[x]r)#n   */
	    op;	   /* token for r in e.g. (sEr)#n	   */
{
	Assign; Compress; Endoper; Execgetr; Exectok; Execspeg; Lifo;
	Newtok; Pop;
	extern Treelist treehdr;
	extern int aplerr;
	int nwa,off;
	Aplcb out=NULL;

	for (;;) { /* lets me use break */
		if (aplerr) break;
		off = tok->token_offset;
		tok->token_ptr.token_deriv->deriv_left.func.wax = compress;
		out = execspeg(tok,axistok,
          	pop(&(treehdr->avlexec->execnxt->avloprst)),&nwa);
		axistok = tok = NULL;
		if (aplerr) break;
          out = assign(op->token_ptr.token_string,out);
		if (aplerr) break;
		lifo(&(treehdr->avlexec->execnxt->avloprst), exectok(out,off));
		out = NULL;
          break;
	}
	if (out != NULL) endoper(out);
	if (tok != NULL) execfree(tok);
	if (axistok != NULL) execfree(axistok);
	if (op != NULL) execfree(op);
	return(1); /* indicate selective specification handled */
}
