/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* execspei APL2 V1.0.0 ************************************************
* Called by execspeh to do selective assignment for a single index	 *
* value, and recursively by itself.  Returns 1 when assignment done.	 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int execspei(pleftorig, left, rite, ix)
Aplcb *pleftorig,/* Variable, elements to which assignment is made.	*/
			  /* Call this "original-left".					*/
	 left,	  /* Variable from which indices were selected. Same	*/
			  /* shape as leftorig, but with unique indices for	*/
			  /* values.  Call this "pseudo-left".				*/
	 rite;	  /* Variable to be assigned from.					*/
int	 ix;		  /* Index into leftorig to element to replace with	*/
			  /* rite.									*/
{
	Endoper; Execspei; Execspej; Temp;
	extern int aplerr;
	Aplcb leftorig,leftsave,*lp,*lop;
	int i,*ip,k=0;

	leftorig = *pleftorig;
	if (left->aplflags & APLAPL) {
		/* --------------------------------------------------------- *
		* Continue recursion until we get to the depth where indices *
		* values can be examined.  Remember, "pseudo-left" has same  *
		* shape as "original-left" but values are unique numbers     *
		* representing relative position of each scalar.             *
		* ----------------------------------------------------------*/
		lp = left->aplptr.aplapl;
		lop = leftorig->aplptr.aplapl;
		i = left->aplcount;
		while(i--) {
			leftsave = *(lop+i);
			if (k = execspei(lop+i,*(lp+i),rite,ix))
				break;
		}
		if (i >= 0 && leftsave != *(lop+i))
			endoper(temp(leftsave));
		return(k); /* indicate assignment done */
	}
	ip = left->aplptr.aplint; /* pointer in "pseudo-left" to indices. */
	if (!(ix >= (k = *ip) && ix <= *(ip+left->aplcount-1)))
		return(0); /* Assignment not in this variable. */
	return(execspej(pleftorig,rite,ix - k)); /* Do assignment. */
}
