/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execspef APL2 V1.0.0 ************************************************
* Called by execsper and execspet to perform selective specification,  *
* e.g. (Er)#n, after the desired indices have been generated.          *
***********************************************************************/
#define INCLUDES APLCB+APLTOKEN+TREE
#include "includes.h"
Apltoken execspef(lefttok, leftorig, left, indices, nwa)
Apltoken lefttok;	/* Token for leftorig. */
Aplcb    leftorig;	/* Variable to which selective assignment is to	*/
				/* be made.								*/
Aplcb    left;		/* Variable of same shape as leftorig, but with	*/
				/* indices as values.						*/
Aplcb    indices;	/* Simple array of integer index values.		*/
int	    nwa;		/* Non-zero if first, pick.    				*/
{
	Assign; Dtacopy; Execfree; Execgetp; Execspeh; Execspen; Exectok;
	Matchok; Pop; Temp;
	extern Treelist treehdr;
	extern int aplerr;
	Apltoken ritetok=NULL;
	Aplcb rite=NULL,saveorig;
	char *ld, *rd, *td;
	int hit,i,*ip,j,off,size,tempsave,type;

	for (;;) { /* lets me use break */
		ritetok = pop(&(treehdr->avlexec->avloprst));
		if (ritetok == NULL) { aplerr = 59; break; }
		off = ritetok->token_offset;
		rite = execgetp(ritetok); /* get rite aplcb, free ritetok */
		if (aplerr) break;
		tempsave = rite->aplflags & APLTEMP;
		if (tempsave) rite->aplflags -= APLTEMP;
		saveorig = leftorig;
		hit = (nwa) ? 
			execspen(&leftorig, left, rite, indices->aplptr.aplint,
				indices->aplcount)
			:
			execspeh(&leftorig, left, rite, indices->aplptr.aplint,
				indices->aplcount);
		if (saveorig != leftorig)
			leftorig = assign(lefttok->token_ptr.token_string,
				temp(leftorig));
		break;
	}
	execfree(lefttok);
	endoper(indices);
	rite->aplflags += tempsave;
	return(exectok(rite,off)); /* Return result operand token. */
}
