/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execsped APL2 V1.0.0 ************************************************
* Called by execspec to perform specification (left arrow)             *
* when it is not selective specification.                              *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+APLCB+TREE
#include "includes.h"
int execsped(tok, op)
Apltoken tok; /* token for next operator */
Apltoken op;  /* token for next operand  */
{
	Axistest; Execdyah; Execfree; Execindx; Lifo;
	extern Treelist treehdr;
	extern int aplerr;
	int noexit=1;

	if (tok != NULL /* no function? */ || op == NULL /* no operand? */) {
		execfree(tok);
		execfree(op);
		aplerr = 66; /* object to assign to not found */
		return(!noexit);
	}
	if (axistest(treehdr->avlexec->avloprst)) {
		op = execindx(op); /* do indexed assignment */
		if (aplerr) return(!noexit);
		op = lifo(&(treehdr->avlexec->avloprst),op);
		return(aplerr == 0);
	}
	else return(execdyah(op)); /* do non-indexed assignment */
}
