/* Copyright (C) 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* execqts APL2 V1.0.0 *************************************************
* Called from execgetq and execgets.                                   *
* System function quad_ts, time stamp.                                 *
***********************************************************************/
#include <time.h>
#define INCLUDES APLCB
#include "includes.h"
Aplcb execqts()
{
	Errinit; Errstop; Execqtzs; Getcb;
     Aplcb out;
	time_t ntime;
	struct tm *t;

	if (errinit()) return(NULL);
	out = getcb(NULL,7,APLINT+APLTEMP,1,NULL);
	if (out == NULL) return(NULL);
	time(&ntime); /* Seconds since 00:00:00 GMT on 1 Jan 1970. */
	ntime += 3600 * (time_t) execqtzs(); /* Offset by local time zone. */
	t = localtime(&ntime); /* Convert to tm structure. */
	*(out->aplptr.aplint+0) = t->tm_year + 1900;	/* year */
	*(out->aplptr.aplint+1) = t->tm_mon + 1;	/* month */
	*(out->aplptr.aplint+2) = t->tm_mday;		/* day of month */
	*(out->aplptr.aplint+3) = t->tm_hour;		/* hour */
	*(out->aplptr.aplint+4) = t->tm_min;		/* minute */
	*(out->aplptr.aplint+5) = t->tm_sec;		/* second */
	*(out->aplptr.aplint+6) = 0;				/* millisecond */
	return(errstop(0,NULL,NULL,out));
}
