/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqfxm APL2 V1.0.0 ************************************************
* Called by execqfx after the character matrix representing the        *
* user-defined function has been successfully converted to an Aplfunc. *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+APLTOKEN+STRING+TREE
#include "includes.h"
Aplcb execqfxm(nametok,fp)
Apltoken nametok;
Aplfunc fp;
{
	Assign; Chrvect; Treenode;
	extern int aplerr;
	extern Treelist treehdr;
	Treelist symp;
	Aplfunc fun;
	Aplcb wrk;
	Avlnode pav;
	char *nameptr = nametok->token_ptr.token_string;

	for (;;) { /* Lets me use break. */
		pav = treenode(nameptr);
		if (pav == NULL) break;
		fun = pav->avlleaf; /* Point to function description. */
		if (fun == NULL) break;
		if (!(fun->funcflag & APLFUNC)) break;
		fp->funcflag |= fun->funcflag; /* Turn on IN_USE. */
		for( symp = (Treelist) treehdr; symp != NULL;
			symp = symp->treenext) { /* Search the tree, */
			if (symp->avlfun == fun)  /* for suspended functions. */
				symp->avlfun = fp; /* Replace with new. */
		}	
		break; /* Final break from for(;;) */
	}
	wrk = assign(nameptr,(Aplcb)fp);
	return(chrvect(nameptr));
}

