/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqfxk APL2 V1.0.0 ************************************************
* Called from execqfxb and apledit after all necessary function        *
* statements have been parsed into token lists pointed to by fp->    *
* functokp.  Execqfxk will count tokens, and reallocate them in a      *
* contiguous block of memory.                                          *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+APLMEM+APLTOKEN
#include "includes.h"
void execqfxk(fp)
struct aplfunc *fp; /* function definition structure */
{
	Execqfxc; Pop;
	extern int aplerr;
	Apltoken fromhdr,tok,*tokary,tohdr,totok;
	int *cntary,stmtcnt,stmtno,subcnt,totcnt;

	stmtcnt = fp->funcstmt;
	totcnt = 0; /* now count tokens */
	cntary = fp->functokc;
	tokary = fp->functokp;
	for (stmtno = 0; stmtno < stmtcnt; stmtno++) {
		subcnt = 0;
		for (tok = *tokary++; tok != NULL; 
			tok = tok->token_queue.token_next_ptr)
			subcnt++;
		*cntary++ = subcnt; /* token count this statement */
		totcnt += subcnt; /* add to grand total */
	}
	fp->functotl = totcnt; /* save total */
	totok = fp->functary = malloc(totcnt * sizeof(struct apltoken));
	if (NULL == totok) return; /* out of memory */
	tokary = fp->functokp; /* now copy tokens */
	for (stmtno = 0; stmtno < stmtcnt; stmtno++) {
		fromhdr = *tokary; /* next from token list header */
		*tokary++ = totok; /* next to-token list header */
		while (NULL != (tok = pop(&fromhdr)))
			totok = execqfxc(totok,tok); /* copy token, bump totok */
	}
}
