/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqfxi APL2 V1.0.0 ************************************************
* Called by execqfx and execqfxi to check for localized synonyms.      *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+APLMEM+APLTOKEN+STDIO+TREE
#include "includes.h"
void execqfxi(fp)
Aplfunc fp; /* Function definition structure. */
{
	Aplclsub; Avladd; Avlsrch;
#include "quadext.h"
	extern int aplerr;
	Treelist mytree;
	Apltoken tok;
	Avlnode p;
	char *nameptr;

	/* First set up a local variable tree. */
	mytree = malloc(sizeof(struct treelist));
	mytree->treenext = NULL;
	mytree->avlhdr = NULL;
	/* Now search list of local variables */
	for (tok = fp->funcvars; tok != NULL && aplerr == 0;
		tok = tok->token_queue.token_next_ptr) {
		switch (tok->token_code) {
			case QUAD_CT:	nameptr = quadct; break;
			case QUAD_IO:	nameptr = quadio; break;
			default:		nameptr = tok->token_ptr.token_string;
		}
		if (NULL != avlsrch(mytree->avlhdr,nameptr))
			aplerr = 96; /* synonyms are bad */
		else p = avladd(&(mytree->avlhdr),nameptr,NULL);
	}
	/* Now search list of local labels */
	for (tok = fp->funclabs; tok != NULL && aplerr == 0;
		tok = tok->token_queue.token_next_ptr) {
		if (NULL != avlsrch(mytree->avlhdr,
			tok->token_ptr.token_string))
			aplerr = 97; /* synonyms are bad */
		else p = avladd(&(mytree->avlhdr),
			tok->token_ptr.token_string,NULL);
	}
	/* Now free up my local tree */
	aplclsub(mytree->avlhdr);
	free(mytree);
}
