/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqfxc APL2 V1.0.0 ************************************************
* Called from execqfxb and execqfxk to copy a token.                   *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLTOKEN
#include "includes.h"
Apltoken execqfxc(totok,fromtok)
Apltoken totok,fromtok;
{
	Aplcopy; Execfree;
	Aplcb cb;

	if (fromtok->token_queue.token_next_ptr == NULL)
		totok->token_queue.token_next_ptr = NULL; /* end of chain */
	else
		totok->token_queue.token_next_ptr = totok + 1;
	totok->token_code = fromtok->token_code;
	totok->token_offset = fromtok->token_offset;
	totok->token_flags = TOKPERM; /* permanent token */
	switch (fromtok->token_code) {
		case QUOTE:
		case VECTOR_TOKEN:
			cb = fromtok->token_ptr.token_vector;
			if (cb->aplflags & APLTEMP) {
				cb->aplflags -= APLTEMP; /* mark permanent */
				totok->token_ptr.token_vector = cb;
				fromtok->token_ptr.token_vector = NULL;
			}
			else
				totok->token_ptr.token_vector = aplcopy(cb);
			break;
		case OPERAND_TOKEN:
			totok->token_ptr.token_string =
				fromtok->token_ptr.token_string;
			fromtok->token_ptr.token_string = NULL;
			break;
		default:
			totok->token_ptr.token_string = NULL;
			break;
	} /* end switch */
	execfree(fromtok); /* free from token */
	return(totok + 1);
}
