/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execoptk APL2 V1.0.0 ************************************************
* Called from execexee to check for an operand token.  Either a        *
* pointer to an operand token is returned, or NULL.                     *
***********************************************************************/
#define INCLUDES APLMEM+APLCHDEF+APLTOKEN+APLCB
#include "includes.h"
Apltoken execoptk(ptok)
Apltoken ptok[]; /* current input token */
{
     Execfree;
     extern int aplerr;
     Apltoken op,tok;

     if (NULL == (tok = *ptok)) return(NULL);
     op = NULL; /* place to store next operand */
     switch (tok->token_code) {
          case OPERAND_TOKEN: /* operand name */
          case QUOTE: /* character vector */
          case VECTOR_TOKEN: /* numeric vector */
          case QUOTE_QUAD: /* terminal I/O */
          case QUAD: /* terminal I/O */
          case QUAD_AI: /* account information */
          case QUAD_AV: /* atomic vector */
          case QUAD_CT: /* comparison tolerance */
          case QUAD_FC: /* format control */
          case QUAD_HT: /* horizontal tabs */
          case QUAD_IO: /* index origin */
          case QUAD_LC: /* line counter */
          case QUAD_LX: /* latent expression */
          case QUAD_PP: /* printing precision */
          case QUAD_PW: /* printing width */
          case QUAD_RL: /* random link */
          case QUAD_TC: /* terminal control */
          case QUAD_TT: /* terminal type */
          case QUAD_TS: /* time stamp */
          case QUAD_TZ: /* time zone */
          case QUAD_UL: /* user load */
          case QUAD_WA: /* working area */
               op = tok; *ptok = NULL; /* eliminate duplicate ref. */
               break;
     } /* end switch */
     return(op); /* return token for operand */
}
