/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execnila APL2 V1.0.0 ************************************************
* Called by execexei when the current token is for a user-defined      *
* niladic function.  It is executed, and the result, if any, is        *
* returned.                                                            *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+APLTOKEN+TREE
#include "includes.h"
Apltoken execnila(tok)
Apltoken tok; /* current token */
{
	Endoper; Execfree; Exectok; Funcmain;
	extern Treelist treehdr;
	extern int aplerr;
	Apltoken op;
	Aplfunc func;
	Aplcb out;
	int off;

	func = tok->token_work; /* save function pointer */
	off = tok->token_offset; /* save offset */
	execfree(tok); /* free token */
	out = funcmain(func,NULL,NULL);
	if (func->functype & RETVAL)
		return(exectok(out,off)); /* niladic w/result */
	if (treehdr->avltokhd != NULL 
		|| treehdr->avlexec->avlfunst != NULL 
		|| treehdr->avlexec->avloprst != NULL)
		aplerr = 94; /* niladic in bad context */
	endoper(out);
	return(NULL); /* ignore result */
}
