/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execmons APL2 V1.0.0 ************************************************
* Called from execmonh, eachmona, to determine monadic function type.  *
***********************************************************************/
#define INCLUDES APLDERIV+FUNSTRUC
#include "includes.h"
int execmons(code,fun,arg,pep)
int code; /* function code */
void *fun; /* function description */
void **arg; /* possible function argument */
sub_dyad *pep; /* derived function entry point */
{
	Derived; Execmoni; Execmonq; Funcmain;
	extern int aplerr;
	int ret;
     

	if (code >= DEFINED_FUNCTION) {
		pep->flr = funcmain;
          ret = FLR;
     }
	else if (code == DERIVED_FUNCTION) {
		pep->flr = derived;
          ret = FLR;
     }
	else if (code == FUNCTION_TOKEN)
     	ret = execmoni(fun,arg,pep);
     else if (code < QUAD_AI)
     	ret = execmonq(code, pep); /* system function? */
     else {
     	aplerr = 73; /* unknown monadic */
          ret = NO_TYPE;
     }
	return(ret);
}
