/* Copyright (C) 1992 by Thomas Glen Smith.  All Rights Reserved. */
/* execmonq APL2 V1.0.0 ************************************************
* Called from execmons to determine if any of the system functions     *
* should be invoked.                                                   *
***********************************************************************/
#define INCLUDES APLCB+APLTOKEN+APLDERIV
#include "includes.h"
int execmonq(code,pep)
int code; /* function/operator code */
sub_dyad *pep; /* derived function entry point */
{
	Execqcr; Execqdl; Execqex; Execqfx; Execqnc; Execqnl;
     int ret=MON;

	switch (code) {
		case QUAD_CR: /* canonical function representation */
			pep->mon = execqcr;
			break;
		case QUAD_DL: /*  */
			pep->mon = execqdl;
			break;
		case QUAD_EX: /*  */
			pep->mon = execqex;
			break;
		case QUAD_FX: /*  */
			pep->mon = execqfx;
			break;
		case QUAD_NC: /*  */
			pep->mon = execqnc;
			break;
		case QUAD_NL: /*  */
          	ret = DIX;
			pep->dix = execqnl;
			break;
		default:
			ret = NO_TYPE;
			break;
	} /* end switch */
	return(ret); /* all done */
}
