/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execmonj - APL2 V1.0.0 **********************************************
* Called from execmonh, eachmona to apply a monadic function,		 *
* producing an Aplcb as output.								 *
***********************************************************************/
#define INCLUDES APLCB+APLDERIV
#include "includes.h"
Aplcb execmonj(ptype,fun,arg,ep,rite,axcb)
deriv_type ptype;
void *fun;
void *arg;
sub_dyad ep;
Aplcb rite;
Aplcb axcb;
{
	Axisdft; Errstop; Execaxiv; Execmonk;
	extern int aplerr;
	Axisdft; Errstop;
	Aplcb out=NULL;
	int axis;

	switch(ptype) {
		case FLR: /* funcmain, derived */
				out = ep.flr(fun,NULL,rite);
			break;
		case DIX: /* transpose, gradedn, gradeup */
				out = ep.dix(NULL,rite);
			break;
		case MEX: /* disclose */
			out = ep.mex(rite,axcb);
			break;
		case MOA: /* scalar monadics */
			if (rite->aplflags & APLAPL)
				out = execmonk(ptype,arg,ep,rite,NULL);
			else out = ep.moa(arg,rite);
			break;
		case MON:
			out = ep.mon(rite);
			break;
		case MOX:
			if (axcb)
				axis = execaxiv(axcb);
			else axis = axisdft((Codes *)fun,rite);
			out = ep.mox(rite,axis);
			break;
		default:
			aplerr = 73; /* unknown monadic */
			endoper(rite);
			break;
	} /* end switch */
	return(errstop(0,NULL,NULL,out));
}
