/*Copyright (C) 1992, 1994 by Thomas Glen Smith.	All Rights Reserved.*/
/* execgetr APL2 V1.0.0 ************************************************
* Called from execgetp to get the Aplcb associated with a token.		 *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLTOKEN
#include "includes.h"
Aplcb execgetr(tok)
Apltoken tok; /* operand token */
{
	Errstop; Execgetq; Execgets; Treesrch;
	extern int aplerr, indxorg;
	Aplcb out=NULL;

	if (!(tok == NULL || aplerr))
		switch (tok->token_code) {
			case OPERAND_TOKEN:
				out = treesrch(tok->token_ptr.token_string);
				if (out == NULL) aplerr = 59; /* undefined operand */
				break;
			case QUOTE:
			case VECTOR_TOKEN:
				out = tok->token_ptr.token_vector;
				if (out != NULL && (out->aplflags & APLTEMP))
					tok->token_ptr.token_vector = NULL;
				break;
			case NULL_TOKEN: /* occurs for a null index value */
				out = NULL;
				break;
			default:
				out = execgets(tok); /* Try QUAD_stuff. */
				if (out != NULL || aplerr) break;
				out = execgetq(tok);
				if (out == NULL) aplerr = 69; /* unknown operand type */
				break;
		}
	return(errstop(0,NULL,NULL,out));
}
