/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execfun APL2 V1.0.0 *************************************************
* Called by dottran.                                                   *
* Called to pop the operator/function stack, returning the             *
* operator/function code and setting offset as a side effect, after    *
* freeing the popped token.                                            *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+APLCB+TREE
#include "includes.h"
int execfun(pfunc)
void **pfunc; /* function definition structure */
{
     Execfree; Getcode; Pop;
     extern Treelist treehdr;
     extern int aplerr;
     Apltoken funtok;
     int code;

     if (NULL == (funtok = pop(&(treehdr->avlexec->avlfunst))))
          aplerr = 63; /* missing operator/function */
     else {
          treehdr->avloff = funtok->token_offset; /* save offset */
          code = getcode(pfunc, funtok);
          execfree(funtok); /* free function/operator token */
     }
     return(code);
}
