/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execfree APL2 V1.0.0 ************************************************
* Called from exectokf, execexec and execterm to free a token.         *
***********************************************************************/
#define INCLUDES APLMEM+APLCHDEF+APLTOKEN+APLCB+APLDERIV
#include "includes.h"
void execfree(tok)
Apltoken tok;
{
     Dervfree; Endoper; Execpop; Pop;
     Apltoken ix;
     Aplderiv dp;

     if (tok == NULL || (tok->token_flags & TOKPERM))
          return; /* nothing to free */
     switch ( tok->token_code ) {
          case QUOTE:
          case VECTOR_TOKEN:
               endoper( tok->token_ptr.token_vector );
               break;
          case OPERAND_TOKEN:
          case CAP_NULL:
               free( tok->token_ptr.token_string );
               break;
          case AXIS_INDEX_TOKEN:
               while (NULL != (ix=pop(&(tok->token_ptr.token_stack))))
                    execfree(ix);
               break;
          case DERIVED_FUNCTION:
               if (dp = tok->token_ptr.token_deriv)
                    dervfree(dp);
               break;
     } /* end switch */
     free( tok ); /* free apltoken structure */
}
