/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execexeg APL2 V1.0.0 ************************************************
* Called by execexee to obtain the next token from the input stack,    *
* after pushing all bracketed axis/index values on the operand stack.  *
* The token returned will be the one just to the left of the leftmost  *
* left bracket of one or more contiguous sets of bracketed values.     *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+APLCB+TREE
#include "includes.h"
Apltoken execexeg()
{
     Execbrkt; Execexej; Execfree; Funexec; Lifo; Pop;
     extern Treelist treehdr;
     extern int aplerr;
     Apltoken tok;
     int savelast;

     for (;;) {
          tok = pop(&(treehdr->avltokhd)); /* pop input */
          treehdr->avloff = tok->token_offset;
          if (!(tok && tok->token_code == AXIS_INDEX_TOKEN))
               break; /* leave loop if not AXIS_INDEX_TOKEN */
          tok = lifo(&(treehdr->avlexec->avloprst), tok);
     }
    	savelast = treehdr->lastfun;
     while (aplerr == 0 && tok->token_code == RIGHT_BRACKET) {
          tok = execbrkt(tok); /* type AXIS_INDEX_TOKEN */
          if (aplerr) break; /* problem getting index/axis stack */
          tok = lifo(&(treehdr->avlexec->avloprst), tok);
               /* stack index/axis stack */
          if (NULL == (tok = pop(&(treehdr->avltokhd))))
               aplerr = 58; /* syntax error */
          else
               treehdr->avloff = tok->token_offset;
	     treehdr->lastfun = savelast;
     }
     if (tok->token_code == RIGHT_PAREN) {
          execfree(tok); /* indicate freed */
          tok = execexej(); /* go evaluate expression */
	     treehdr->lastfun = savelast;
     }
     return(funexec(tok)); /* Token left of leftmost left bracket. */
          /* Funexec will transform all function/operator tokens into */
          /* tokens of type FUNCTION_TOKEN. */
}
