/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execexed APL2 V1.0.0 ************************************************
* Called by execexec, execexej, execspeg,                              *
* to perform execute mainline processing.                              *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLFUNCI+APLTOKEN+FUNSTRUC+STDIO+TREE
#include "includes.h"
void execexed()
{
     Execdyah; Execfree; Execmong; Execnext; Execspec; Lifo;
     extern Treelist treehdr;
     extern int aplerr;
     Apltoken axistok,op,tok;
     int noexit;

     axistok = tok = NULL;
     while (aplerr == 0) {
          noexit = execnext(&tok,&axistok,&op,NULL);
          if (aplerr) break;
          if (op) /* did execnext find any operands? */
               if (!execdyah(op)) break;
          if (axistok) {
               execmong(); /* do monadics on stack */
               axistok = lifo(&(treehdr->avlexec->avlfunst),axistok);
               axistok = NULL;
          }
          if (tok != NULL) {
          	if (!(tok->token_code == FUNCTION_TOKEN &&
               	((Codes *)(tok->token_ptr.token_function))->funky_code
                    == BASE_NULL))
	          	treehdr->lastfun = tok->token_code;
          	if (!execspec(&tok)) /* do monadics, assignment */
	               break; /* execexee/execspec said to quit */
          }
          if (!noexit) break; /* execnext said to quit */
     }
     execfree(axistok);
     execfree(tok);
     execmong(); /* do remaining monadics on stack */
}
