/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execdyas APL2 V1.0.0 ************************************************
* Called from dottran, eachdyad, execdyak, and slashtrc to determine   *
* the dyadic derived function type, as described in aplderiv.h         *
***********************************************************************/
#define INCLUDES APLDERIV
#include "includes.h"
int execdyas(fun,arg,pep)
void *fun; /* funstruct */
void **arg; /* possible derived function argument */
sub_dyad *pep; /* derived function entry point */
{
     Execdyap; Execdyaq; Execdyar; Execdyau; Execdyav;
     extern int aplerr;
     sub_dyad ep;

     *pep = ep = execdyap(fun,arg);
     if (ep.flr)
          return(FLR); /* FLR is described in aplderiv.h */
     *pep = ep = execdyaq(fun);
     if (ep.dix)
          return(DIX); /* DIX is described in aplderiv.h */
     *pep = ep = execdyau(fun);
     if (ep.dnl)
          return(DNL); /* DNL is described in aplderiv.h */
     *pep = ep = execdyar(fun);
     if (ep.wax)
          return(WAX); /* WAX is described in aplderiv.h */
     *pep = ep = execdyav(fun);
     if (ep.dox)
          return(DOX); /* DOX is described in aplderiv.h */
     aplerr = 65; /* unknown dyadic */
     return(NO_TYPE);
}
