/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execdyal APL2 V1.0.0 ************************************************
* The entry point to execdyal is returned by execdyap to execdyas when *
* the function is type EQNE.  Execdyas stores the entry point to       *
* execdyal in dp->deriv_left.func, the address of which is passed to   *
* execdyas by slashtrc.  Redscan tests for dp->deriv_left.func being   *
* equal to either execdyal or execdyam, and if so, and the data type   *
* is other than APLAPL, it processes the current operation as a        *
* primitive dyadic scalar.                                             *
***********************************************************************/
#define INCLUDES APLCB+FUNSTRUC
#include "includes.h"
Aplcb execdyal(pfun,left,rite)
void *pfun; /* function structure - see funstruc.h */
Aplcb left,rite; /* function arguments */
{
     Dyadicp; Execdyat;
     int lefttype,ritetype;

     lefttype = left->aplflags & (APLMASK + APLAPL); /* data type */
     ritetype = rite->aplflags & (APLMASK + APLAPL); /* data type */
     if (lefttype == APLAPL || ritetype == APLAPL)
     	return(execdyat(pfun,left,rite,execdyal));
     else return(dyadicp(pfun,left,rite));
}
