/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execdyad APL2 V1.0.0 ************************************************
* Called from execdyah to do a standard APL dyadic function.		 *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+FUNSTRUC+APLCB+TREE
#include "includes.h"
Apltoken execdyad(lefttok,ritetok)
Apltoken lefttok,ritetok; /* tokens for left & right operands */
{
	Execasgn; Execdyac; Execdyan; Execfun; Execgetp;
	extern int aplerr;
	extern Treelist treehdr;
	Aplcb left=NULL,out=NULL,rite=NULL;
	void *func;
	int code,hit;

	code = execfun(&func); /* pop oper/func */
	for (;;) { /* So I can use break in case of error. */
		if (aplerr) break;
		rite = execgetp(ritetok); /* get rite aplcb, free ritetok */
		ritetok = NULL; /* So we don't try to free twice. */
		if (aplerr) break;
		if (code == LEFT_ARROW) {
			out = execasgn(lefttok,rite); /* Do assignment. */
			lefttok = NULL; /* So we don't try to free twice. */
			rite = NULL; /* So we don't try to free twice. */
			break; /* All done. */
		}
		left = execgetp(lefttok); /* get left aplcb, free lefttok */
		lefttok = NULL; /* So we don't try to free twice. */
		if (aplerr) break;
		if (code == FUNCTION_TOKEN &&
			((Codes *)func)->funky_code == RIGHT_SHOE &&
			left->aplcount == 0)
			treehdr->treeflag |= NOT_WHOLE_ARRAY;
		out = execdyan(code,func,left,rite);
		left = rite = NULL; /* So we don't try to free twice. */
		break; /* Get out of for(;;) */
	}
	return(execdyac(lefttok,ritetok,left,rite,out,treehdr->avloff));
}
