/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execdota APL2 V1.0.0 ************************************************
* Called from execdot when the data types of the two operands agree,   *
* and neither data type is character, to do inner product.             *
***********************************************************************/
#define INCLUDES APLTOKEN+APLCHDEF+APLCB+FUNSTRUC
#include "includes.h"
Aplcb execdota(left,rite,type,lscp,rscp)
Aplcb left,rite;   /* left and right operands */
int type;                   /* data types of left and right operands */
Scalar_dyadics *lscp,*rscp; /* function definitions - see aplstruc.h */
{
     Execdotc; Innrprdp;
     Aplcb out=NULL;
     double complex_identity[2];

     switch(type) {
          case APLCPLX:
               if (NULL != rscp->procs.ppcpx)
                    if (NULL != lscp->procs.ppcpx) {
                    	complex_identity[0] = lscp->identities.did;
                         complex_identity[1] = 0e0;
                         out = innrprdp(lscp->procs.ppcpx,rscp->procs.ppcpx,
                              complex_identity,left,rite);
                    }
               if (out != NULL) break;
          case APLINT:
               if (NULL != rscp->procs.ppint)
                    if (NULL != lscp->procs.ppint)
                         out = innrprdp(lscp->procs.ppint,rscp->procs.ppint,
                              &(lscp->identities.iid),left,rite);
               if (out != NULL) break;
          case APLNUMB:
               out = execdotc(left,rite,type,type,lscp,rscp);
               break;
     } /* end switch */
     return(out);
}
