/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* enqueue APL2 V1.0.0 *************************************************
* Called to insert a new element in a doubly linked list.              *
***********************************************************************/
#define INCLUDES 0
#include "includes.h"
typedef struct el *El;
struct el { /* stack entry */
	El nxt;
	El lst;
};
void enqueue(hdr,old,new)
El hdr;	/* head of list */
El old;	/* element behind which to enqueue */
El new;	/* element to add to list */
{

	if (hdr->nxt == NULL) { /* empty list? */
		hdr->nxt = hdr->lst = new;
		new->nxt = new->lst = NULL;
	}
	else if (old == NULL) { /* new head of list? */
		old = hdr->nxt;
		hdr->nxt = new;
		new->nxt = old;
		old->lst = new;
		new->lst = NULL;
	}
	else { /* insert or new tail */
		new->nxt = old->nxt;
		if (new->nxt == NULL)
			hdr->lst = new; /* set new tail */
		else new->nxt->lst = new;
		old->nxt = new;
		new->lst = old;
	}
}
