/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* enlista APL2 V1.0.0 *************************************************
* Called by enlist to determine the count of elements and the datatype *
* of the result for the enlist of rite.                                *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
void enlista(pcount, pdatatype, rite)
int *pcount;    /* Set by enlista to count of items in output. */
int *pdatatype; /* Set by enlista to data type of output. */
Aplcb rite;     /* Argument to be enlisted. */
{
	extern int aplerr;
	void enlista(int *, int *, Aplcb);
	Aplcb *cb, work;
	int i,thistype;

	thistype = rite->aplflags & (APLMASK + APLAPL);
	if (thistype == APLAPL)
		for( cb = rite->aplptr.aplapl, i = rite->aplcount;
			i; i--, cb++)
			enlista(pcount, pdatatype, *cb);
	else {
		*pcount += rite->aplcount;
		if (*pdatatype != thistype)
			switch(*pdatatype) {
				case 0: /* First time - initialize. */
                    	*pdatatype = thistype;
                         break;
				case APLINT:
					if (thistype == APLNUMB || thistype == APLCPLX)
						*pdatatype = thistype; /* conversion ok */
					else *pdatatype = APLAPL;
					break;
				case APLNUMB:
                    	if (thistype == APLCPLX)
						*pdatatype = thistype; /* conversion ok */
					else if (thistype != APLINT)
						*pdatatype = APLAPL; /* conversion not ok */
					break;
				default:
                    	*pdatatype = APLAPL; /* conversion not ok */
                         break;
			}
	}
}
