/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* each APL2 V1.0.0 ****************************************************
* Called by eachtran.                                                  *
* Derived function routine to handle each.                             *
***********************************************************************/
#define INCLUDES APLCHDEF+FUNSTRUC+APLDERIV+APLCB
#include "includes.h"
Aplcb each(dp,left,rite)
Aplderiv dp; /* structure describing derived function */
Aplcb left,rite; /* arguments */
{
	Aplcopy; Eachdyad; Eachmona; Errinit; Errstop;
	Aplcb out=NULL;

	if (errinit())
		out = errstop(0,left,rite,NULL);
	else {
		if (!(rite->aplflags & APLTEMP)) { /* If it's not temp, */
			rite = aplcopy(rite);	/* It could be replaced */
			rite->aplflags |= APLTEMP; /* during each. */
		}
		if (left) {
			if (!(left->aplflags & APLTEMP)) {
				left = aplcopy(left);
				left->aplflags |= APLTEMP;
			}
			out = eachdyad(dp,left,rite);
		}
		else out = eachmona(dp,rite);
	}
	return(out);
}
