/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* dyadic APL2 V1.0.0 **************************************************
* Extends dyadic scalar functions such as plus and minus to conformable*
* pairs of APL variables item-by-item.  The arguments must either agree*
* in shape, or one must have only a single element, which is repeatedly*
* matched with elements of the other.  If both arguments have one item,*
* but differing ranks, the result has the higher rank.                 *
* example:                                                             *
*   dyadic(plus,litvect("1 2 3"),litvect("4 5 6"));                    *
*   produces the vector 5 7 9.                                         *
* example:                                                             *
*   dyadic(plus,litvect("1"),litvect("4 5 6"));                        *
*   produces the vector 5 6 7.                                         *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb dyadic(oper,left,rite)
double (*oper)(); /* operator */
Aplcb left,rite; /* operands */
{
	Dyadicm; Errstop; Matchok;
	extern int aplerr;
	double *dataout,*leftptr,*riteptr;
	int i,leftinc,riteinc;
	Aplcb out;

	if (!matchok(&left,&rite,APLNUMB))
		return(NULL); /* m/b real */
	out=dyadicm(left,rite,
		((void **)&dataout),((void **)&leftptr),((void **)&riteptr),
		&leftinc,&riteinc,APLNUMB
		); /* go build APLCB */
#include "dyadcom.h"
}
