/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* dtacopy APL2 V1.0.0 *************************************************
* Called by reshape, reverse, squadix, and without.                    *
* Copies any of the supported APL data types.                          *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
void *dtacopy(to,from,count,incr,type)
void *to,*from;
int count,incr,type;
{
     Aplcopy; Chrcopy; Dblcopy; Intcopy;
     Aplcb *myto,*myfrom;
     int i;
     void *wrk;

     switch (type) {
     	case APLCPLX:
          	for (i = count; i; i--) {
               	to = dblcopy(to,from,2,1);
                    ((double *)from) += incr * 2;
               }
               return(to);
          case APLNUMB:
               return(dblcopy(to,from,count,incr));
          case APLINT:
               return(intcopy(to,from,count,incr));
          case APLCHAR:
               return(chrcopy(to,from,count,incr));
          case APLAPL:
               myto = to;
               myfrom = from;
               while(count--) {
                    *myto++ = aplcopy(*myfrom);
                    myfrom += incr;
               }
               return(myto);
     } /* end switch */
     return(NULL); /* bad */
}
