/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* drop APL2 V1.0.0 ****************************************************
* Called by drop2.                                                     *
* Drop is analogous to take, except the indicated elements are dropped *
* instead of taken.                                                    *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb drop(left,rite)
Aplcb left,rite;
{
	Errstop; Iabs; Idyadic; Ieq; Imin; Iminus; Imonadic; Inegativ;
	Integer; Iplus; Iscalar; Isign; Itimes; Perm; Shape; Takeck;
	Takeit; Temp; Vectin;
	extern int aplerr;
	Aplcb dimcb,takecb;
	int savetemp;

	if (OK != takeck(&left,&rite) || aplerr)
		return(errstop(0,left,rite,NULL));
	if (savetemp = rite->aplflags & APLTEMP)
		rite->aplflags -= APLTEMP; /* temporarily permanent */
	dimcb=perm(shape(rite)); /* takeck forces rite not scalar */
	takecb=perm(
		idyadic(itimes,
			idyadic(iplus,
				idyadic(ieq,iscalar(0),left),
				imonadic(inegativ, /* reverse the sign for take */
					imonadic(isign,left)
				)
			),
			idyadic(iminus,
				dimcb, /* subtract amount to drop from each */
				idyadic(imin, /* dimension */
					dimcb,
					imonadic(iabs,left)
				)
			)
		)
	);
	endoper(temp(left));
	endoper(temp(dimcb));
	rite->aplflags += savetemp;
	return(takeit(takecb,rite));
}
