/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* dottran - APL2 V1.0.0 ***********************************************
* x49.eptok is set by funinit (see funassgo.h) to point to dottran.	 *
* Called from execexee via "noexit = fun->eptok(tok)".				 *
* Transforms a dot token into a derived function.					 *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+FUNSTRUC+APLDERIV+APLCB
#include "includes.h"
int dottran(tok)
Apltoken tok; /* token for dieresis */
{
	Execdot; Execfree; Execfun; Execjot; Execjot2; Execnext;
	Newderiv; Pickdyad; Slasherr;
	extern int aplerr;
	Apltoken axistok,funtok,op;
	Aplderiv dp;
	int code, noexit=1;
	void *lfun,*rfun;

	code = execfun(&rfun); /* pop rite operator/function */
	if (aplerr) return(noexit);
	dp = newderiv(NULL,NULL,NULL);
	if (aplerr) return(noexit);
	dp->deriv_rite.sdp = pickdyad(rfun); /* pick dyadic scalar */
	dp->deriv_rite.fun = rfun;
	dp->deriv_rite.funcode = code;
	noexit = execnext(&funtok,&axistok,&op,NULL); /* get left func */
	if (funtok == NULL || op || axistok)
		aplerr = 63; /* missing operator */
	if (aplerr) {
		slasherr(funtok,op,axistok,dp);
		return(noexit);
	}
	dp->deriv_left.fun = lfun = funtok->token_ptr.token_function;
	dp->deriv_left.funcode = funtok->token_code;
	execfree(funtok); /* funtok, op, axistok have now all been freed */
	if (((Codes *)lfun)->funky_code == APL_NULL)
		if (dp->deriv_rite.sdp == NULL) {
			dp->deriv_func = execjot2;
			if (DERIVED_FUNCTION == dp->deriv_rite.funcode) {
				dp->deriv_rite.type = DRV;
				dp->deriv_rite.func.drv =
		          	((Aplderiv)(dp->deriv_rite.fun))->deriv_func;
		     }
			else dp->deriv_rite.type = execdyas(dp->deriv_rite.fun,
				&(dp->deriv_rite.sdp),&(dp->deriv_rite.func));
		}
		else dp->deriv_func = execjot;
	else {
		dp->deriv_func = execdot;
		dp->deriv_left.sdp = pickdyad(lfun); /* pick dyadic scalar */
	}
	tok->token_code = DERIVED_FUNCTION;
	tok->token_ptr.token_function = dp;
	return(noexit);
}
