/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* dequeue APL2 V1.0.0 *************************************************
* Called by apledfr.                                                   *
* Dequeue is called to remove an element from a doubly-linked list.    *
* Returns a pointer to the prior element in the list.                  *
***********************************************************************/
#define INCLUDES 0
#include "includes.h"
typedef struct el *El;
struct el { /* stack entry */
	El nxt;
	El lst;
};
struct el *dequeue(hdr,del)
El hdr;	/* head of list */
El del;	/* element to dequeue */
{
	El pre,suc;

	pre = del->lst; /* predecessor in list, or NULL if first */
	suc = del->nxt; /* successor in list, or NULL if last */
	if (pre == NULL)
		hdr->nxt = suc;
	else pre->nxt = suc;
	if (suc == NULL)
		hdr->lst = pre;
	else suc->lst = pre;
	return(pre);
}
