/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* circulay APL2 V1.0.0 ************************************************
* Called by circulax. Circle functions for complex numbers, arc-       *
* hyperbolic trigonometric ATANH, ACOSH, ASINH.                        *
***********************************************************************/
#define INCLUDES MATH+TRIGKEYS
#include "includes.h"
void circulay(left,rrr,ret)
double *left,*rrr,*ret;
{
	Acoshx; Asinhx; Atanhx;
	extern int aplerr;

	switch ((int) *left) {
		case ATANH: atanhx(rrr,ret); break;
		case ACOSH: acoshx(rrr,ret); break;
		case ASINH: asinhx(rrr,ret); break;
		default: aplerr = 85; return; /* left invalid */
	} /* end switch */
}
