/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* circulav APL2 V1.0.0 ************************************************
* Called by circulax. Circle functions for complex numbers, hyperbolic *
* trigonometric TANH, COSH, SINH.                                      *
***********************************************************************/
#define INCLUDES MATH+TRIGKEYS
#include "includes.h"
void circulav(left,rrr,ret)
double *left,*rrr,*ret;
{
	Circulax; Dividex; Expx; Minusx; Plusx;
	extern int aplerr;
	int ileft;
	double b,ixr[2],key,wa[2],wb[2],wc[3],wd[2],x,y;
	static double
		iii[2]={0.0,1.0},
		one[2]={1.0,0.0},
		two[2]={2.0,0.0};

	switch (ileft = (int) *left) {
		case  SINH:	/* sinh r = (*r_1%*r)%2 */
			expx(rrr,wa);			/* wa = *r		*/
			dividex(one,wa,wb);		/* wb = 1%*r		*/
			minusx(wa,wb,wc);		/* wc = *r_1%*r	*/
			dividex(wc,two,ret);	/*ret = (*r_1%*r)%2 */
			break;
		case  COSH:	/* cosh r = (*r+1%*r)%2 */
			expx(rrr,wa);			/* wa = *r		*/
			dividex(one,wa,wb);		/* wb = 1%*r		*/
			plusx(wa,wb,wc);		/* wc = *r+1%*r	*/
			dividex(wc,two,ret);	/*ret = (*r+1%*r)%2 */
			break;
		case  TANH:	/* tanh r = (t_s)%t+s#1%t#*r */
			expx(rrr,wa);			/* wa = *r		*/
			dividex(one,wa,wb);		/* wb = 1%*r		*/
			minusx(wa,wb,wc);		/* wc = t_s		*/
			plusx(wa,wb,wd);		/* wd = t+s#1%t#*r	*/
			dividex(wc,wd,ret);		/*ret = (t_s)%t+s#1%t#*r */
			break;
		default: aplerr = 85; return; /* left invalid */
	} /* end switch */
}
