/* Copyright (C) 1994, 1998 by Thomas Glen Smith.  All Rights Reserved. */
/* circulap APL2 V1.0.1 ************************************************
* Implementation of the APL circular, hyperbolic, and Pythagorean      *
* functions.                                                           *
***********************************************************************/
#define INCLUDES MATH
#include "includes.h"
void circulap(left,rite,ret)
double *left,*rite,*ret;
{
	Acosh; Asinh; Atanh; Sqrt;
	extern int aplerr;
	extern double fuzz;
	double wrk;
	int ii;

	wrk = *rite;
	switch (ii = *left) {
		case -7: *ret = atanh(wrk); break;
		case -6: *ret = acosh(wrk); break;
		case -5: *ret = asinh(wrk); break;
		case -4: *ret = (sqrt(-1.0+wrk*wrk)); break;
		case -3: *ret = (atan(wrk)); /* Arctan */ break;
		case -2: /* Arccos */
		case -1: /* Arcsin */
			if (wrk > 1.0) {
				if ((wrk - 1.0) < fuzz) wrk = 1.0;
			} else if (*rite < -1.0) {
				if ((wrk + 1.0) < fuzz) wrk = -1.0;
			}
			*ret = (ii == -2) ? acos(wrk): asin(wrk);
			break;
		case  0: *ret = (sqrt(1-wrk*wrk)); break;
		case  1: *ret = (sin(wrk)); /* Sine */ break;
		case  2: *ret = (cos(wrk)); /* Cosine */ break;
		case  3: *ret = (tan(wrk)); /* Tangent */ break;
		case  4: *ret = (sqrt(1.0+wrk*wrk)); break;
		case  5: *ret = (sinh(wrk)); /* Hyperbolic sine */ break;
		case  6: *ret = (cosh(wrk)); /* Hyperbolic cosine */ break;
		case  7: *ret = (tanh(*rite)); /* Hyperbolic tangent */ break;
		default: aplerr = 85; *ret = (0.0); /* *left invalid */ break;
	} /* end switch */
}
