/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* chrvect APL2 V1.0.0 *************************************************
* Called by execqfxm.                                                  *
* The argument is a character string.  Returned is a pointer to an     *
* APLCB for an APL variable of type character.                         *
***********************************************************************/
#define INCLUDES APLCB+STRING
#include "includes.h"
Aplcb chrvect(sp)
char *sp;
{
	Chrcopy; Errinit; Errstop; Getcb;
	char *cp;
	int datacnt,rank;
	Aplcb out;

	if (errinit())
		return(NULL);
	datacnt = strlen(sp); /* number of characters in result */
	if (datacnt == 1)
		rank = 0; /* scalar output */
	else rank = 1; /* vector output */
	out = getcb(NULL,datacnt,APLCHAR+APLTEMP,rank,NULL);
	if (out->aplcount)
		cp = chrcopy(out->aplptr.aplchar,sp,out->aplcount,1);
	return(errstop(0,NULL,NULL,out));
}
