/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* charcode APL2 V1.0.0 ************************************************
* Called by aplscan.                                                   *
* Call charcode with a string representing an APL character, such as   *
* would be returned by codechar(), and it will return the integer code *
* for that character.  See also function codechar().                   *
***********************************************************************/
#define INCLUDES STRING
#include "includes.h"
int charcode(kp)
char *kp;
{
     extern char *aplchar[]; /* APL character set */
     extern int aplchax[]; /* Collated indexes to APL character set */
     extern int aplchno; /* number of elements in aplchar */
     int i,j,k,m,n;

     i = 0;
     j = aplchno-1;
     while (i <= j) {
          m = (i + j) / 2; /* index to middle element in aplchar */
          n = aplchax[m]; /* actual index */
          switch (isign(strcmp(kp,aplchar[n]))) {
               case -1: /* *kp < *(aplchar[n]) */
                    j = m - 1; /* look in lower half */
                    break;
               case  0: /* *kp == *(aplchar[n]) */
                    return(n); /* return proper code */
                    break;
               case +1: /* *kp > *(aplchar[n]) */
                    i = m + 1; /* look in upper half */
                    break;
          }
     }
     return(-1); /* not found */
}
