/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* avltree APL2 V1.0.0 *************************************************
* Called by avladdsb to add a new node to an AVL-balanced binary tree, *
* providing a node with the same name doesn't already exist.  If a node*
* with the name already exists, its node address will be returned.     *
* Otherwise, the new node is added, and NIL is returned.               *
***********************************************************************/
#define INCLUDES STRING+TREE
#include "includes.h"
Avlnode avltree(parmhdr,newnode)
Avlnode *parmhdr,newnode;
{
	Avlnode a,b,c,cl,cr,f,p,q;
	int d;

	newnode->left_child = newnode->rite_child = NULL;
	newnode->avlbf = 0; /* balance factor = 0 */
	if (*parmhdr == NULL) { /* special case - empty tree */
		*parmhdr = newnode; /* tree has one node */
		return(NULL);
	}
	#include "avltsub1.h"
	#include "avltsub2.h"
	#include "avltsub3.h"
	#include "avltsub4.h"

	/* Subtree with root b has been rebalanced and is the new subtree
	of f.  The original subtree of f had root a. */

	if (f == NULL) *parmhdr = b;
	else if (a == f->left_child) f->left_child = b;
	else if (a == f->rite_child) f->rite_child = b;
	return(NULL); /* OK */
}
