/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* atanh APL2 V1.0.0 ***************************************************
* Hyperbolic arc-tangent.                                              *
***********************************************************************/
#define INCLUDES MATH
#include "includes.h"
double atanh(rite)
double rite;
{
	Log;
	extern int aplerr;
	double diff, ret;

	if (rite == 0) return(0.0);
	diff = (1.0 < rite) ? rite - 1.0 : 1.0 - rite;
	if (diff < 1e-13) {
		aplerr = 84; /* bad argument to function */
		return(0.0);
	}
	ret = log((1+rite)/(1-rite))/2;
	return(ret);
}
