/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplwkst APL2 V1.0.0 *************************************************
* Called by apl to process commands beginning with a right parenthesis *
* that have been deferred for execution.                               *
***********************************************************************/
#define MAXLINE 100
#define INCLUDES APLCB+APLCHDEF+STRING
#include "includes.h"
int aplwkst()
{
	Aplclear; Aplload; Endoper;
#include "aplwkcd.h"
	extern int aplerr;
	extern struct aplcb *aplwkcb;
	extern char *aplwkcp,*aplwken;
	extern int aplwkcd;
	char *cp,*cpend,wrk[MAXLINE];
	int ret=1;

	aplerr = 0;
	switch (aplwkcd) {
		case CLEAR:	
			aplclear();
			break;
		case LOAD:
			if (MAXLINE <= strlen(aplwkcb->aplptr.aplchar))
				aplerr = 999; /* internal error */
			else {
				strcpy(wrk, aplwkcb->aplptr.aplchar);
				cp = wrk + (aplwkcp - aplwkcb->aplptr.aplchar);
				cpend = cp + (aplwken - aplwkcp);
				endoper(aplwkcb);
				aplwkcb = NULL;
				aplwkcp = aplwken = NULL;
				aplload(wrk,cp,cpend);
			}
			break;
		case OFF:	
			ret = 0; /* terminate loop in caller */
			break;
		default:
			ret = 1; /* spurious */
			break;
	} /* end switch */
	if (aplwkcb != NULL)
		endoper(aplwkcb);
	aplwkcb = NULL;
	aplwkcd = 0;
	return(ret);
}
