/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplscan APL2 V1.0.0 *************************************************
* Called from funcsusq.                                                *
* The argument is a pointer to a pointer to a string of text.  Aplscan *
* returns one of the integers in aplchdef.h indicating what the next   *
* APL character representation found in the string is.  Tabs (\t),     *
* newlines (\t), and the APL space character which are in a contiguous *
* aggregate will be indicated as a single APL SPACE character.  The    *
* text pointer will be updated by aplscan to point to the next         *
* character beyond the current APL character representation.  APL      *
* character representations are defined in external character array    *
* called aplchar.                                                      *
***********************************************************************/
#define INCLUDES APLCHDEF+STRING
#include "includes.h"
int aplscan(sp,spend)
char *sp[]; /* pointer to pointer to string being parsed */
char *spend; /* pointer to after end of string */
{
	Charcode;
	extern char *aplchar[];
	char *s,work[APLMXLN+1];
	int i,j;

	for (s = sp[0]; s < spend && *s == *(aplchar[SPACE])
		|| *s == '\n' || *s == '\t'; s++); /* white space */
	if (s != sp[0])
		j = SPACE; /* current APL character */
	else for (i = 0, j = UNKNOWN; i < APLMXLN && s < spend; i++) {
		work[i] = *s++;
		work[i+1] = '\0';
		j = charcode(work); /* is this a valid APL character? */
		if (j != UNKNOWN)
			break;
	}
	sp[0] = s; /* update text pointer */
	return(j);
}
