/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplreae APL2 V1.0.0 *************************************************
* Called from aplread after the file has been read to create an APL    *
* variable from the input, naming it "file."                           *
***********************************************************************/
#define INCLUDES APLCB+APLMEM
#include "includes.h"
typedef struct lines *Lines;
struct lines {
	Lines nextline;	/* Next line in queue. */
	int tlen;				/* Length of this line. */
	char th;				/* Beginning of string. */
};
void aplreae(hdr,cols,rows)
Lines hdr;	/* Head of lines queue.	*/
int cols;			/* Columns in output.	*/
int rows;			/* Rows in output.		*/
{
	Assign; Chrcopy; Getcb;
	extern int aplerr;
	char *op;
	Lines cur,nxt;
	Aplcb out;
	int i;

	out = getcb(NULL,rows*cols,APLCHAR+APLTEMP,2,NULL); /* Get aplcb. */
	if (out != NULL) {
		*(out->apldim) = rows; /* Fill in dimension 1. */
		*(out->apldim + 1) = cols; /* Fill in dimension 2. */
		op = out->aplptr.aplchar; /* First output location */
		for (cur = hdr; cur != NULL; cur = cur->nextline) {
			op = chrcopy(op, &(cur->th), cur->tlen, 1); /* copy */
			if (0 < (i = cols - cur->tlen))
				op = chrcopy(op, " ", i, 0); /* pad */
		}
		out = assign("file",out); /* Go do assignment. */
	}
}
