/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplread APL2 V1.0.0 *************************************************
* Called from aplwksp to do )READ.                                     *
***********************************************************************/
#define INCLUDES APLCB+APLMEM+STDIO
#include "includes.h"
#define MAXLINE 1024
void aplread(rite,cp,cpend)
Aplcb rite; /* aplcb for command text */
char *cp; /* Pointer to char immediately after right parenthesis */
char *cpend; /* Pointer to end of command text */
{
	Aplfopn; Aplreae; Chrcopy; Fifo;
	extern int aplerr;
	FILE *fp;
	char ch,line[MAXLINE];
	int cols=0,linelen=0,*op,rows=0;
	typedef struct lines *Lines;
	struct lines {
		Lines nextline;
		int tlen; /* length of this line */
	} *hdr,*cur=NULL,*nxt;
	Aplcb out;

	if (NULL == (fp = aplfopn(cp,cpend,"r")))
		return; /* Couldn't open input file. */
	for (;;) {
		ch = fgetc(fp); /* get next input character */
		if (ch != EOF && ch != '\n')
			line[linelen++] = ch; /* Add to current line. */
		else { /* end of current line */
			if (EOF == ch && linelen == 0)
				break; /* done reading lines */
			nxt = malloc(sizeof(struct lines)+linelen);
			if (nxt == NULL)
				break; /* Out of storage. */
			chrcopy(sizeof(struct lines) + (char*)nxt,
				line,linelen,1); /* copy string */
			rows++;
			cols = (linelen > cols) ? linelen : cols;
			nxt->tlen = linelen; /* save string length */
			cur = fifo(&hdr,cur,nxt); /* add to queue */
			if (EOF == ch)
				break; /* done reading lines */
			linelen = 0; /* get set for next line */
		}
	}
	fclose(fp); /* close file */
#if APL_DOS
	errno = 0; /* clear any error for close */
#endif
	if (aplerr == 0)
		aplreae(hdr,cols,rows); /* Go complete )READ processing. */
	for (cur = hdr; cur != NULL; cur = nxt) {
		nxt = cur->nextline;
		free(cur); /* Free memory for queue. */
	}
}
