/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplputch APL2 V1.0.0 ************************************************
* Called by aplprint and gettcom.                                      *
* APL interface to putchar().  Setting aplfont to 1 executes for       *
* a special APL font.                                                  *
***********************************************************************/
#define INCLUDES STDIO+STRING
#include "includes.h"
void aplputch(ch)
char ch;
{
	extern int aplfont;
	static unsigned int accent = '`', last = 0;

	if (aplfont) {
		if (ch < 32) last = 0; /* ignore garbage */
		if (last) {
			last = 0;
			putchar(ch+128); /* print alternate */
		}
		else if (ch == accent)
			last = 1; /* accented character */
		else putchar(ch);
	}
	else putchar(ch);
}
