/* Copyright (C) 1992 by Thomas Glen Smith.  All Rights Reserved. */
/* aplparsf APL2 V1.0.0 ************************************************
* Called from aplparse for each newly parsed token to perform special  *
* processing, and look for syntactical errors based on token_code.     *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN
#include "includes.h"
void aplparsf(cur,ss,t,u,bracket_count_ptr,paren_count_ptr)
Apltoken cur;    /* most recent token */
char **ss;               /* pointer in string yet to be tokenized. */
char *t;                 /* points to start of most recent token. */
char *u;                 /* points after end of string to tokenize. */
int *bracket_count_ptr;  /* count for matching brackets */
int *paren_count_ptr;    /* count for matching parentheses. */
{
     Aplpnam; Aplpnum; Aplquad; Aplquote;

     switch (cur->token_code) {
          case ALPHABET: /* name */
               aplpnam(cur,t,ss,u);
               cur->token_code = OPERAND_TOKEN;
               break;
          case CAP_NULL:
               aplpnam(cur,t,ss,u);
               cur->token_code = CAP_NULL;
               break;
          case DIGIT:
          case DOT:
          case OVERBAR:
               aplpnum(cur,ss,u); /* numeric constant */
               break;
          case LEFT_BRACKET: (*bracket_count_ptr)++; break;
          case LEFT_PAREN: (*paren_count_ptr)++; break;
          case QUAD: aplquad(cur,ss,u); /* Lio or Lav */ break;
          case QUOTE: aplquote(cur,ss,u); /* quoted string */ break;
          case RIGHT_BRACKET:
               if (0 > --(*bracket_count_ptr)) {
                    cur->token_code = MESSAGE_TOKEN;
                    cur->token_ptr.token_string =
                         "unbalanced brackets";
               }
               break;
          case RIGHT_PAREN:
               if (0 > --(*paren_count_ptr)) {
                    cur->token_code =  MESSAGE_TOKEN;
                    cur->token_ptr.token_string =
                         "unbalanced parentheses";
               }
               break;
          case UNKNOWN: /* bad character */
               cur->token_code = MESSAGE_TOKEN;
               cur->token_ptr.token_string = "Unknown character.";
               break;
     } /* end switch */
}
