/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* aplnest APL2 V1.0.0 *************************************************
* Called by pickit and squadix.                                        *
* Copies the specified APL variable to a variable of type APLAPL. Each *
* element in the input becomes a nested element in the output.		 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb aplnest(Aplcb rite)
{
	extern int aplerr;
	Dtacopy; Errstop; Getcb; Intcopy;
	Aplcb *op, out, wrk;
	int dtatype,i;
	char *ip;

	out = getcb(NULL,rite->aplcount,APLAPL+APLTEMP,rite->aplrank,NULL);
	if (aplerr) return(NULL);
	if (out->aplrank > 1) /* rank higher than vector? */
		intcopy(out->apldim, rite->apldim, out->aplrank, 1);
	if (i = out->aplcount) {
		dtatype = rite->aplflags & (APLMASK + APLAPL);
		ip = rite->aplptr.aplchar;
		op = out->aplptr.aplapl;
		while (i--) {
			if (aplerr)
				wrk = NULL;
			else wrk = getcb(NULL, 1, dtatype, 0, NULL);
			if (aplerr == 0) {
				dtacopy(wrk->aplptr.aplint, ip, 1, 1, dtatype);
                    ip += rite->aplsize;
			}
               *op++ = wrk;
		}
	}
	return(errstop(0, NULL, rite, out));
}
