/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* aplmatci APL2 V1.0.0 ************************************************
* Called by aplmatch, without, and recursively by itself.  Yields 1 if *
* ld and rd are identical in shape and value.                          *
* One of these states must exist pertaining to data types:             *
* 1)  Types are equal.  Can be any of the possible types.              *
* 2)  Types are both APL_NUMERIC (APLINT, APLNUMB, or APLCPLEX).       *
* 3)  One of the two types must be APLAPL.                             *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int aplmatci(Apluptr ld, Apluptr rd, int lefttype, int ritetype)
{
     Aplmatch; Aplmatci; Aplmatcj; Eq; Xeq;
     extern int aplerr;
     Aplcb cb;
     Apluptr dataptr;
     int cbtype,datatype;
     double xl[2],xr[2];


	if (lefttype == APLAPL || ritetype == APLAPL)
     	return(aplmatck(ld, rd, lefttype, ritetype));
	if (lefttype == APLCPLX || ritetype == APLCPLX) {
     	aplmatcj(ld, lefttype, xl);
          aplmatcj(rd, ritetype, xr);
          return(xeq(xl,xr));
     }
     switch(lefttype | ritetype) {
          case APLCHAR:
               return(*ld.aplchar == *rd.aplchar);
          case APLINT:
               return(*ld.aplint == *rd.aplint);
          case APLNUMB:
               return(eq(*ld.apldata,*rd.apldata));
          case APLNUMB + APLINT:
               if (lefttype == APLNUMB)
                    return(eq(*ld.apldata,*rd.aplint));
               else return(eq(*ld.aplint,*rd.apldata));
          default:
          	return(0); /* no match */
     } /* end switch */
}
