/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplgrous APL2 V1.0.0 ************************************************
* Called from aplgroup after the stack of new group member names has   *
* been created, aplgrous will create the new group name aplcb and call *
* assign with it.                                                      * 
***********************************************************************/
#define INCLUDES APLCB+APLTOKEN+STRING
#include "includes.h"
void aplgrous(pgrphdr,rows,cols,nameptr)
Apltoken *pgrphdr;			/* fifo stack of new names */
int rows;					/* ptr to new row count */
int cols;					/* ptr to new col count */
char *nameptr;				/* group name */
{
	Aplstr; Assign; Getcb;
	Aplcb out;
	Apltoken tok;
	char *cp;

	out = getcb(NULL,rows*cols,APLCHAR+APLTEMP+APLGROUP,2,NULL);
	if (out == NULL) return; /* out of storage */
	*(out->apldim) = rows;
	*(out->apldim + 1) = cols;
	cp = out->aplptr.aplchar;
	for (tok = *pgrphdr; tok != NULL;
		tok = tok->token_queue.token_next_ptr)
		cp = aplstr(cp, tok->token_ptr.token_string, cols);
	out = assign(nameptr,out); /* add name to variable pool */
}
